const db = require('../config/dbConnect');


// const getLastAgentByCustomer = (customer_number, did_number) => {
//   return new Promise((resolve, reject) => {
//     const query = `
//       SELECT agent_id, agent_name, agent_number, start_stamp 
//       FROM agent_call_logs 
//       WHERE caller_id_number = ? AND did_number = ? 
//       ORDER BY start_stamp DESC 
//       LIMIT 1
//     `;

//     const queryParams = [customer_number, did_number];

//     // Debug print: constructed query with values
//     const debugQuery = query.replace(/\?/g, () => `'${queryParams.shift()}'`);
//     console.log('Executing SQL:', debugQuery); // 👈 shows final query

//     db.query(query, [customer_number, did_number], (err, results) => {
//       if (err) {
//         return reject(err);
//       }
//       resolve(results); // results is an array
//     });
//   });
// };

// const getLastAgentByCustomer = (customer_number) => {
//   return new Promise((resolve, reject) => {
//     const query = `
//       SELECT agent_id, agent_name, agent_number, start_stamp 
//       FROM agent_call_logs 
//       WHERE customer_number = ? 
//         AND direction = 'clicktocall'
//         AND agent_number IS NOT NULL
//       ORDER BY start_stamp DESC 
//       LIMIT 1
//     `;

//     const queryParams = [customer_number];

//     // Debugging: build full query with injected values
//     const debugQuery = query.replace(/\?/g, () => `'${queryParams.shift()}'`);
//     console.log('Executing SQL:', debugQuery);

//     db.query(query, [customer_number], (err, results) => {
//       if (err) {
//         return reject(err);
//       }
//       resolve(results.length ? results[0] : null);
//     });
//   });
// };

const getLastAgentByCustomer = (customer_number) => {
  return new Promise((resolve, reject) => {
    const query = `
      SELECT full_json 
      FROM agent_call_logs 
      WHERE customer_number = ? 
        AND direction = 'clicktocall'
      ORDER BY start_stamp DESC 
      LIMIT 1
    `;

    db.query(query, [customer_number], (err, results) => {
      if (err) return reject(err);
      resolve(results.length ? results[0] : null); // results[0] is your row
    });
  });
};


const saveCallLog = async (data) => {
  const customer_number = data.call_to_number?.startsWith('+')
    ? data.call_to_number
    : '+' + data.call_to_number;

    console.log('customer_number', customer_number);

  const sql = `
    INSERT INTO agent_call_logs (
      uuid, call_id, call_to_number, caller_id_number, start_stamp,
      answer_stamp, end_stamp, hangup_cause, duration, billsec,
      agent_id, agent_name, agent_number, did_number, customer_number,
      direction, call_status, reason_key, recording_url, full_json
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
  `;

  const values = [
    data.uuid,
    data.call_id,
    customer_number,
    data.caller_id_number,
    data.start_stamp,
    data.answer_stamp,
    data.end_stamp,
    data.hangup_cause,
    parseInt(data.duration) || 0,
    parseInt(data.billsec) || 0,
    data.answered_agent?.id || null,
    data.answered_agent_name || null,
    data.answered_agent_number || null,
    data.caller_id_number,
    customer_number,
    data.direction,
    data.call_status,
    data.reason_key,
    data.recording_url,
    JSON.stringify(data)
  ];

  return await db.query(sql, values);
};


const saveDialerCallLog = async (data) => {
  const sql = `INSERT INTO dialercallog (json, created_at) VALUES (?, ?);`;
  const values = [JSON.stringify(data), new Date()];
  return await db.query(sql, values);
}


module.exports = { getLastAgentByCustomer, saveCallLog, saveDialerCallLog };