const { createUser, login, createEnquiry, getmeta, subscribe } = require('../api/controller');
const { checkToken } = require('../auth/token_validation');

const router = require('express').Router();

// Auth API Routes 
router.post("/user" ,checkToken, createUser);
router.post("/login", login);

// Enquiry Route Here 

router.post("/",checkToken , createEnquiry);
router.get("/fetchmeta/:metasource", checkToken, getmeta);

// subscribe Route Here 

router.get("/subscribe/:email", checkToken, subscribe);





module.exports = router;