const mysql = require('mysql');
require('dotenv').config();

//create MySql Connection 

const db = mysql.createConnection({
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASS || '',
    database: process.env.DB_NAME || 'acefone',
});

//connect to MySql
db.connect((err) => {
    if (err) {
        console.error('Error connecting to MySql: ' + err.stack);
        return;
    }
    console.log('MySql Connected...');
});


module.exports = db;