const db = require("../config/dbConnect");

// Function to get all api keys
const getApiKey = (apikey) => {
  return new Promise((resolve, reject) => {
    db.query(
      "SELECT * FROM api_keys WHERE api_key = ?",
      [apikey],
      (err, result) => {
        if (err) {
          return reject(err);
        }
        resolve(result);
      }
    );
  });
};

module.exports = {
  getApiKey,
};
