const apiKeyModel = require('../model/apikeyModel');

const checkApiKey = async (req, res, next) => {
   
    const apiKey = req.headers['x-api-key'];
    if (!apiKey) {
        return res.status(403).json({ message: 'No API Key provided' });
    }

    try {
        const results = await apiKeyModel.getApiKey(apiKey);
        if (results.length === 0) {
            return res.status(403).json({ message: 'Invalid API Key' });
        }
        next();
        
    } catch (error) {
        console.log(error);
        return res.status(500).json({message: 'Database error', error: error });
        
    }
};

module.exports = {checkApiKey};